#!/usr/bin/perl

#
# "diff-grader": just compare sample output and contestant output
#   IGNORING any EOL characters
#
# A toned down version of the actual grader used in CEOI 2008
#
# Version 20080714
#
# usage:
#    grader.pl <input-file> <sample-output-file> <contestant-output-file>
#
# output: 
#   grade-run.out 
#     contains "perfect" or causes of incorrect result
#   report.out
#     contains 1 if the output is to receive full score
#     contains 0 if the output is to receive no score
#

use strict;

sub report {
    my $ok = shift;
    if (! defined $ok) {
        die "report(): argument ok missing";
    }
    my $message = shift;
    if (! defined $message) {
        die "report(): argument message missing";
    }
    open(REPORT, "> grade-run.out");
    print REPORT "$message\n";
    close(REPORT);
    open(REPORT, "> report.out");
    print REPORT "$ok\n";
    close(REPORT);
    exit 0;
}

my $inputFile = shift;
if (! defined $inputFile) {
  die "usage!";
}
my $sampleFile = shift;
if (! defined $sampleFile) {
    die "usage!";
}
my $contestantFile = shift;
if (! defined $contestantFile) {
    die "usage!";
}

open (SAMPLE, "< $sampleFile") or die "could not open sample output: $!";
open (INFILE, "< $inputFile") or die "could not open input file: $!";
open (CONTESTANT, "< $contestantFile") or report(0, "opening $contestantFile: $!");

#
# INFORMATION SPECIFIC FROM HERE ON
#

my $l = <INFILE> or die "input format";
$l =~ /(\d+) (\d+)\n/ or die "input format";

my $N=$1+0;
my $M=$2+0;

my %used;

my @from;
my @to;
$#from = $M+1;
$#to = $M+1;
for (my $i = 1; $i <= $M; $i++) {
	$l = <INFILE> or die "input format";
	$l =~ /(\d+) (\d+)\n/ or die "input format";
	$from[$i] = $1+0;
	$to[$i] = $2+0;
}

$l = join(" ", <CONTESTANT>);
my @l = split /\s+/, $l;
shift @l if $l[0] eq "";

if (join("", <SAMPLE>) eq "NONE\n") {
	if ($l[0] ne "NONE") {
		report(0, "the correct answer is NONE.");
	}
	if (@l > 1) {
		report(0, "garbage at end of file");
	}
	report(1, "perfect.");
}

my @graph;
my %visited;
my %missing;
for (my $i = 1; $i <= 2; $i++) {
	undef @graph;
	$#graph = $N+1;
	for (my $i = 1; $i <= $N; $i++) {
	    my %a;
	    $graph[$i] = \%a;
	}

	for (my $m = 0; $m < $N - 1; $m++) {
		my $e = shift @l;
		report(0, "early end of file") if not defined $e;
		report(0, "correct answer is not NONE.") if $e eq "NONE";
		report(0, "invalid output format") if $e !~ /^\d+$/;
		$e += 0;
		if ($e < 1 || $e > $M) {
			report(0, "invalid edge index $e on line $i");
		}
		if (defined $used{$e}) {
			report(0, "edge $e has already been used for message part $i");
		}
		${$graph[$from[$e]]}{$to[$e]} = 1;
		$used{$e} = $i;
	}

	undef %missing;
	for (my $v = 1; $v <= $N; $v++) {
		$missing{$v} = 1;
	}

	sub dfs {
		my $v = shift;
		delete $missing{$v};
		foreach my $w (keys %{$graph[$v]}) {
			if (defined $missing{$w}) {
				dfs($w);
			}
		}
	}

	dfs(1);

	if (keys %missing != 0) {
		my $a = (keys %missing)[0];
		report(0, "agent $a did not recieve part $i of the message");
	}
}

if (defined shift @l) {
    report (0, "garbage at end of file");
}

report(1, "perfect.");

