#include <iostream>
#include <fstream>
#include <vector>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string>
using namespace std;

typedef pair<int,int> PI;
typedef vector<PI> VPI;

int K,N;

VPI IN;

const int VALID_MOVES[][2] = {{-2,+1}, {-2,-1}, {-1,-2}, {+1,-2} };
#include "inc.h"
#include "formula.h"

void report(int score, string msg){
	cout<<score<<endl<<msg<<endl;
	exit(0);
}

void early_eof(){
	report(0,"early end of file");
}

string YES("YES");
string NO("NO");

PI readKnight(){
	int x[2];
	cin>>ws;
	if (cin.eof()) early_eof();
	cin>>x[0]>>ws;
	if (cin.eof()) early_eof();
	cin>>x[1]>>ws;
	return PI(x[0],x[1]);
}

string itoa(int x){
	char buf[100];
	sprintf(buf,"%d",x);
	return string(buf);
}

int main(int argc, char**argv){
	if (argc < 2) { 
		cout<<"usage: grader <input-file> <contestant-output-file>"<<endl; 
		exit(1); 
	}
	ifstream in(argv[1]);

	in>>K>>N;

	int best=0;

	for (int k=0;k<K;k++){
		int x,y;in>>x>>y;
		IN.push_back(PI(x,y));
		if (abs(f(x,y))>abs(best))
			best=f(x,y);
	}

	int WIN = best>0;

	close(0);
	if (open(argv[2],O_RDONLY) != 0)
		report(0,"no output produced");


	string RESULT;
	cin>>ws;

	if (cin.eof()) early_eof();
	cin>>RESULT>>ws;

	if (RESULT==YES){
		if (!WIN)
			report(0,"read 'YES' but Alice can't win the game");
	}else if (RESULT==NO){
		if (WIN)
			report(0,"read 'NO' but Alice can win the game");
		report(1,"perfect");
	}else{
		report(0,"expected 'YES' or 'NO'");
	}
	
	VPI OUT;

	for (int k=0;k<K;k++){
		PI o=readKnight();
		OUT.push_back(o);
		int valid=0;
		for (int m=0;m<4;m++){
			if (o.first==IN[k].first+VALID_MOVES[m][0] && o.second==IN[k].second+VALID_MOVES[m][1])
				valid=1;
		}
		if (!valid)
			report(0,"invalid move. can't move from ("+itoa(IN[k].first)+string(",")+itoa(IN[k].second)+string(") to (")+itoa(o.first)+string(",")+itoa(o.second)+string(")."));
	}

	int nbest=0;

	for (int k=0;k<K;k++){
		if (abs(f(OUT[k].first,OUT[k].second))>abs(nbest))
			nbest=f(OUT[k].first,OUT[k].second);
	}

	int nWIN = nbest>0;

	if (nWIN==1)
		report(0,"the game can be won, but after the proposed move Alice can't win the game anymore.");

	report(1,"perfect");
}
