/**
 * Checks that the input is according to the problem description
 *
 * EXPECTED SCORE: 0
 */

#include <iostream>
#include <set>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
using namespace std;

typedef pair<int,int> PI;
typedef set<PI> SPI;

//Alice and Bob are playing a game. Initially $K$ black Knights are placed on a $N \times N$ chessboard. 
//Now the players take turns. On each turn, a player moves every knight that has at least one valid move left.
//The following moves are valid, as long as they do not move the knight off the board:

int VALID_MOVES[][2] = { {-2,-1}, {-2,+1}, {-1,-2}, {+1,-2} };

//A knight with no valid moves left remains at its current position. The first player
//who is not able to move any of the knights loses the game. Note that during the game several
//knights are allowed to occupy the same square.

//You are given the locations of the knights on the chessboard. Alice begins the game. Determine whether she can win the game, assuming that both players play optimally.

void die(int condition=0,const char*reason=""){
	if (condition)
		return;
	cout<<"Error: "<<reason<<endl;
	exit(1);
}

int range(const int x, const int from=0, const int to=INT_MAX){
	die(from<to);
	return (x>=from)&&(x<=to);
}

int integer(const int from=0, const int to=INT_MAX){
	die(cin.good());
	if (!isdigit(cin.peek()))
		cout<<"expected digit but found '"<<(char)cin.peek()<<"' instead."<<endl,die();
	int ret;cin>>ret;
	if (!range(ret,from,to))
		cout<<"expected integer in range {"<<from<<",...,"<<to<<"} but found "<<ret<<endl,die();
	return ret;
}

void space(){
	die(cin.good(),"space");
	if (cin.peek()!=' ')
		cout<<"expected space but found '"<<(char)cin.peek()<<"' instead."<<endl,die(0);
	cin.get();
}

void newline(){
	die(cin.good(),"newline");
	if (cin.peek()!='\n')
		cout<<"expected newline but found '"<<(char)cin.peek()<<"' instead."<<endl,die(0);
	cin.get();
}

void eof(){
	die(cin.good(),"eof");
	if (cin.peek()!=EOF)
		cout<<"expected EOF but found '"<<(char)cin.peek()<<"' instead."<<endl,die(0);
}

int main () {
	//The first line contains the two integers $K$ and $N$ ($1 \le K,N \le 1,000,000$) separated by a single space. 
	
	const int K=integer(1,200000);
	space();
	const int N=integer(1,1000000);
	newline();

	SPI S;

	//This line is followed by $K$ lines describing the positions of the knights.
	
	for (int k=0;k<K;k++){
		//Line $i+1$ contains two integers $x_i$ and $y_i$ ($1\le x_i$, $y_i\le N$) separated by a single space, the
		//coordinates of the $i^{\text{th}}$ knight.
		const int x=integer(1,N);
		space();
		const int y=integer(1,N);
		newline();
		//There is at least one valid move for each of the knights at the start 
		int ok=0;
		for (int i=0;i<4;i++)
			ok|=range(x+VALID_MOVES[i][0],1,N)&&range(y+VALID_MOVES[i][1],1,N);
		die(ok,"knight can't move");

		S.insert(PI(x,y));
	}
	//and no two knights are placed on the same square of the chessboard initially.
	die((int)S.size()==K,"two knights in the same position");

	eof();

	cout<<"Ok."<<endl;
}
